// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The ServerVulnerabilityAssessmentsSettingKindName. </summary>
    public readonly partial struct ServerVulnerabilityAssessmentsSettingKindName : IEquatable<ServerVulnerabilityAssessmentsSettingKindName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServerVulnerabilityAssessmentsSettingKindName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServerVulnerabilityAssessmentsSettingKindName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureServersSettingValue = "azureServersSetting";

        /// <summary> azureServersSetting. </summary>
        public static ServerVulnerabilityAssessmentsSettingKindName AzureServersSetting { get; } = new ServerVulnerabilityAssessmentsSettingKindName(AzureServersSettingValue);
        /// <summary> Determines if two <see cref="ServerVulnerabilityAssessmentsSettingKindName"/> values are the same. </summary>
        public static bool operator ==(ServerVulnerabilityAssessmentsSettingKindName left, ServerVulnerabilityAssessmentsSettingKindName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServerVulnerabilityAssessmentsSettingKindName"/> values are not the same. </summary>
        public static bool operator !=(ServerVulnerabilityAssessmentsSettingKindName left, ServerVulnerabilityAssessmentsSettingKindName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServerVulnerabilityAssessmentsSettingKindName"/>. </summary>
        public static implicit operator ServerVulnerabilityAssessmentsSettingKindName(string value) => new ServerVulnerabilityAssessmentsSettingKindName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServerVulnerabilityAssessmentsSettingKindName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServerVulnerabilityAssessmentsSettingKindName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
