// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The kind of the server vulnerability assessments setting. </summary>
    internal readonly partial struct ServerVulnerabilityAssessmentsSettingKind : IEquatable<ServerVulnerabilityAssessmentsSettingKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServerVulnerabilityAssessmentsSettingKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServerVulnerabilityAssessmentsSettingKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureServersSettingValue = "AzureServersSetting";

        /// <summary> AzureServersSetting. </summary>
        public static ServerVulnerabilityAssessmentsSettingKind AzureServersSetting { get; } = new ServerVulnerabilityAssessmentsSettingKind(AzureServersSettingValue);
        /// <summary> Determines if two <see cref="ServerVulnerabilityAssessmentsSettingKind"/> values are the same. </summary>
        public static bool operator ==(ServerVulnerabilityAssessmentsSettingKind left, ServerVulnerabilityAssessmentsSettingKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServerVulnerabilityAssessmentsSettingKind"/> values are not the same. </summary>
        public static bool operator !=(ServerVulnerabilityAssessmentsSettingKind left, ServerVulnerabilityAssessmentsSettingKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServerVulnerabilityAssessmentsSettingKind"/>. </summary>
        public static implicit operator ServerVulnerabilityAssessmentsSettingKind(string value) => new ServerVulnerabilityAssessmentsSettingKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServerVulnerabilityAssessmentsSettingKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServerVulnerabilityAssessmentsSettingKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
