// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The selected vulnerability assessments provider on Azure servers in the defined scope. </summary>
    public readonly partial struct ServerVulnerabilityAssessmentsAzureSettingSelectedProvider : IEquatable<ServerVulnerabilityAssessmentsAzureSettingSelectedProvider>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServerVulnerabilityAssessmentsAzureSettingSelectedProvider"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServerVulnerabilityAssessmentsAzureSettingSelectedProvider(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MdeTvmValue = "MdeTvm";

        /// <summary> Microsoft Defender for Endpoints threat and vulnerability management. </summary>
        public static ServerVulnerabilityAssessmentsAzureSettingSelectedProvider MdeTvm { get; } = new ServerVulnerabilityAssessmentsAzureSettingSelectedProvider(MdeTvmValue);
        /// <summary> Determines if two <see cref="ServerVulnerabilityAssessmentsAzureSettingSelectedProvider"/> values are the same. </summary>
        public static bool operator ==(ServerVulnerabilityAssessmentsAzureSettingSelectedProvider left, ServerVulnerabilityAssessmentsAzureSettingSelectedProvider right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServerVulnerabilityAssessmentsAzureSettingSelectedProvider"/> values are not the same. </summary>
        public static bool operator !=(ServerVulnerabilityAssessmentsAzureSettingSelectedProvider left, ServerVulnerabilityAssessmentsAzureSettingSelectedProvider right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServerVulnerabilityAssessmentsAzureSettingSelectedProvider"/>. </summary>
        public static implicit operator ServerVulnerabilityAssessmentsAzureSettingSelectedProvider(string value) => new ServerVulnerabilityAssessmentsAzureSettingSelectedProvider(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServerVulnerabilityAssessmentsAzureSettingSelectedProvider other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServerVulnerabilityAssessmentsAzureSettingSelectedProvider other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
