// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The provisioningState of the vulnerability assessment capability on the VM. </summary>
    public readonly partial struct ServerVulnerabilityAssessmentPropertiesProvisioningState : IEquatable<ServerVulnerabilityAssessmentPropertiesProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServerVulnerabilityAssessmentPropertiesProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServerVulnerabilityAssessmentPropertiesProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string DeprovisioningValue = "Deprovisioning";

        /// <summary> Succeeded. </summary>
        public static ServerVulnerabilityAssessmentPropertiesProvisioningState Succeeded { get; } = new ServerVulnerabilityAssessmentPropertiesProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static ServerVulnerabilityAssessmentPropertiesProvisioningState Failed { get; } = new ServerVulnerabilityAssessmentPropertiesProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static ServerVulnerabilityAssessmentPropertiesProvisioningState Canceled { get; } = new ServerVulnerabilityAssessmentPropertiesProvisioningState(CanceledValue);
        /// <summary> Provisioning. </summary>
        public static ServerVulnerabilityAssessmentPropertiesProvisioningState Provisioning { get; } = new ServerVulnerabilityAssessmentPropertiesProvisioningState(ProvisioningValue);
        /// <summary> Deprovisioning. </summary>
        public static ServerVulnerabilityAssessmentPropertiesProvisioningState Deprovisioning { get; } = new ServerVulnerabilityAssessmentPropertiesProvisioningState(DeprovisioningValue);
        /// <summary> Determines if two <see cref="ServerVulnerabilityAssessmentPropertiesProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ServerVulnerabilityAssessmentPropertiesProvisioningState left, ServerVulnerabilityAssessmentPropertiesProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServerVulnerabilityAssessmentPropertiesProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ServerVulnerabilityAssessmentPropertiesProvisioningState left, ServerVulnerabilityAssessmentPropertiesProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServerVulnerabilityAssessmentPropertiesProvisioningState"/>. </summary>
        public static implicit operator ServerVulnerabilityAssessmentPropertiesProvisioningState(string value) => new ServerVulnerabilityAssessmentPropertiesProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServerVulnerabilityAssessmentPropertiesProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServerVulnerabilityAssessmentPropertiesProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
