// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The value type of the items in the list. </summary>
    public readonly partial struct SecurityValueType : IEquatable<SecurityValueType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityValueType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityValueType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IPCidrValue = "IpCidr";
        private const string StringValue = "String";

        /// <summary> An IP range in CIDR format (e.g. '192.168.0.1/8'). </summary>
        public static SecurityValueType IPCidr { get; } = new SecurityValueType(IPCidrValue);
        /// <summary> Any string value. </summary>
        public static SecurityValueType String { get; } = new SecurityValueType(StringValue);
        /// <summary> Determines if two <see cref="SecurityValueType"/> values are the same. </summary>
        public static bool operator ==(SecurityValueType left, SecurityValueType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityValueType"/> values are not the same. </summary>
        public static bool operator !=(SecurityValueType left, SecurityValueType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityValueType"/>. </summary>
        public static implicit operator SecurityValueType(string value) => new SecurityValueType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityValueType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityValueType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
