// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Status of the IoT Security solution. </summary>
    public readonly partial struct SecuritySolutionStatus : IEquatable<SecuritySolutionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecuritySolutionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecuritySolutionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static SecuritySolutionStatus Enabled { get; } = new SecuritySolutionStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static SecuritySolutionStatus Disabled { get; } = new SecuritySolutionStatus(DisabledValue);
        /// <summary> Determines if two <see cref="SecuritySolutionStatus"/> values are the same. </summary>
        public static bool operator ==(SecuritySolutionStatus left, SecuritySolutionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecuritySolutionStatus"/> values are not the same. </summary>
        public static bool operator !=(SecuritySolutionStatus left, SecuritySolutionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecuritySolutionStatus"/>. </summary>
        public static implicit operator SecuritySolutionStatus(string value) => new SecuritySolutionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecuritySolutionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecuritySolutionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
