// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The SecuritySettingName. </summary>
    public readonly partial struct SecuritySettingName : IEquatable<SecuritySettingName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecuritySettingName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecuritySettingName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string McasValue = "MCAS";
        private const string WdatpValue = "WDATP";
        private const string WdatpExcludeLinuxPublicPreviewValue = "WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW";
        private const string WdatpUnifiedSolutionValue = "WDATP_UNIFIED_SOLUTION";
        private const string SentinelValue = "Sentinel";

        /// <summary> MCAS. </summary>
        public static SecuritySettingName Mcas { get; } = new SecuritySettingName(McasValue);
        /// <summary> WDATP. </summary>
        public static SecuritySettingName Wdatp { get; } = new SecuritySettingName(WdatpValue);
        /// <summary> WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW. </summary>
        public static SecuritySettingName WdatpExcludeLinuxPublicPreview { get; } = new SecuritySettingName(WdatpExcludeLinuxPublicPreviewValue);
        /// <summary> WDATP_UNIFIED_SOLUTION. </summary>
        public static SecuritySettingName WdatpUnifiedSolution { get; } = new SecuritySettingName(WdatpUnifiedSolutionValue);
        /// <summary> Sentinel. </summary>
        public static SecuritySettingName Sentinel { get; } = new SecuritySettingName(SentinelValue);
        /// <summary> Determines if two <see cref="SecuritySettingName"/> values are the same. </summary>
        public static bool operator ==(SecuritySettingName left, SecuritySettingName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecuritySettingName"/> values are not the same. </summary>
        public static bool operator !=(SecuritySettingName left, SecuritySettingName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecuritySettingName"/>. </summary>
        public static implicit operator SecuritySettingName(string value) => new SecuritySettingName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecuritySettingName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecuritySettingName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
