// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The issue that caused the resource to by unhealthy. </summary>
    public partial class SecurityHealthReportIssue
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityHealthReportIssue"/>. </summary>
        /// <param name="issueKey"> The unique issue key. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="issueKey"/> is null. </exception>
        public SecurityHealthReportIssue(string issueKey)
        {
            Argument.AssertNotNull(issueKey, nameof(issueKey));

            IssueKey = issueKey;
            SecurityValues = new ChangeTrackingList<string>();
            IssueAdditionalData = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="SecurityHealthReportIssue"/>. </summary>
        /// <param name="issueKey"> The unique issue key. </param>
        /// <param name="issueName"> The issue name. </param>
        /// <param name="securityValues"> The affected security values that MDC offers that will be affected by the issue, for example: recommendations, alerts, etc. </param>
        /// <param name="issueDescription"> The issue description. </param>
        /// <param name="remediationSteps"> Human readable description of what you should do to mitigate this health issue. </param>
        /// <param name="remediationScript"> The remediation script to solve this issue. </param>
        /// <param name="issueAdditionalData"> Additional data for the given issue. The additional data depends on the issue type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityHealthReportIssue(string issueKey, string issueName, IList<string> securityValues, string issueDescription, string remediationSteps, string remediationScript, IDictionary<string, string> issueAdditionalData, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IssueKey = issueKey;
            IssueName = issueName;
            SecurityValues = securityValues;
            IssueDescription = issueDescription;
            RemediationSteps = remediationSteps;
            RemediationScript = remediationScript;
            IssueAdditionalData = issueAdditionalData;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityHealthReportIssue"/> for deserialization. </summary>
        internal SecurityHealthReportIssue()
        {
        }

        /// <summary> The unique issue key. </summary>
        public string IssueKey { get; set; }
        /// <summary> The issue name. </summary>
        public string IssueName { get; set; }
        /// <summary> The affected security values that MDC offers that will be affected by the issue, for example: recommendations, alerts, etc. </summary>
        public IList<string> SecurityValues { get; }
        /// <summary> The issue description. </summary>
        public string IssueDescription { get; set; }
        /// <summary> Human readable description of what you should do to mitigate this health issue. </summary>
        public string RemediationSteps { get; set; }
        /// <summary> The remediation script to solve this issue. </summary>
        public string RemediationScript { get; set; }
        /// <summary> Additional data for the given issue. The additional data depends on the issue type. </summary>
        public IDictionary<string, string> IssueAdditionalData { get; }
    }
}
