// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> A valid event source type. </summary>
    public readonly partial struct SecurityEventSource : IEquatable<SecurityEventSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityEventSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityEventSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AssessmentsValue = "Assessments";
        private const string AssessmentsSnapshotValue = "AssessmentsSnapshot";
        private const string SubAssessmentsValue = "SubAssessments";
        private const string SubAssessmentsSnapshotValue = "SubAssessmentsSnapshot";
        private const string AlertsValue = "Alerts";
        private const string SecureScoresValue = "SecureScores";
        private const string SecureScoresSnapshotValue = "SecureScoresSnapshot";
        private const string SecureScoreControlsValue = "SecureScoreControls";
        private const string SecureScoreControlsSnapshotValue = "SecureScoreControlsSnapshot";
        private const string RegulatoryComplianceAssessmentValue = "RegulatoryComplianceAssessment";
        private const string RegulatoryComplianceAssessmentSnapshotValue = "RegulatoryComplianceAssessmentSnapshot";

        /// <summary> Assessments. </summary>
        public static SecurityEventSource Assessments { get; } = new SecurityEventSource(AssessmentsValue);
        /// <summary> AssessmentsSnapshot. </summary>
        public static SecurityEventSource AssessmentsSnapshot { get; } = new SecurityEventSource(AssessmentsSnapshotValue);
        /// <summary> SubAssessments. </summary>
        public static SecurityEventSource SubAssessments { get; } = new SecurityEventSource(SubAssessmentsValue);
        /// <summary> SubAssessmentsSnapshot. </summary>
        public static SecurityEventSource SubAssessmentsSnapshot { get; } = new SecurityEventSource(SubAssessmentsSnapshotValue);
        /// <summary> Alerts. </summary>
        public static SecurityEventSource Alerts { get; } = new SecurityEventSource(AlertsValue);
        /// <summary> SecureScores. </summary>
        public static SecurityEventSource SecureScores { get; } = new SecurityEventSource(SecureScoresValue);
        /// <summary> SecureScoresSnapshot. </summary>
        public static SecurityEventSource SecureScoresSnapshot { get; } = new SecurityEventSource(SecureScoresSnapshotValue);
        /// <summary> SecureScoreControls. </summary>
        public static SecurityEventSource SecureScoreControls { get; } = new SecurityEventSource(SecureScoreControlsValue);
        /// <summary> SecureScoreControlsSnapshot. </summary>
        public static SecurityEventSource SecureScoreControlsSnapshot { get; } = new SecurityEventSource(SecureScoreControlsSnapshotValue);
        /// <summary> RegulatoryComplianceAssessment. </summary>
        public static SecurityEventSource RegulatoryComplianceAssessment { get; } = new SecurityEventSource(RegulatoryComplianceAssessmentValue);
        /// <summary> RegulatoryComplianceAssessmentSnapshot. </summary>
        public static SecurityEventSource RegulatoryComplianceAssessmentSnapshot { get; } = new SecurityEventSource(RegulatoryComplianceAssessmentSnapshotValue);
        /// <summary> Determines if two <see cref="SecurityEventSource"/> values are the same. </summary>
        public static bool operator ==(SecurityEventSource left, SecurityEventSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityEventSource"/> values are not the same. </summary>
        public static bool operator !=(SecurityEventSource left, SecurityEventSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityEventSource"/>. </summary>
        public static implicit operator SecurityEventSource(string value) => new SecurityEventSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityEventSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityEventSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
