// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The type of security control (for example, BuiltIn). </summary>
    public readonly partial struct SecurityControlType : IEquatable<SecurityControlType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityControlType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityControlType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BuiltInValue = "BuiltIn";
        private const string CustomValue = "Custom";

        /// <summary> Microsoft Defender for Cloud managed assessments. </summary>
        public static SecurityControlType BuiltIn { get; } = new SecurityControlType(BuiltInValue);
        /// <summary> Non Microsoft Defender for Cloud managed assessments. </summary>
        public static SecurityControlType Custom { get; } = new SecurityControlType(CustomValue);
        /// <summary> Determines if two <see cref="SecurityControlType"/> values are the same. </summary>
        public static bool operator ==(SecurityControlType left, SecurityControlType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityControlType"/> values are not the same. </summary>
        public static bool operator !=(SecurityControlType left, SecurityControlType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityControlType"/>. </summary>
        public static implicit operator SecurityControlType(string value) => new SecurityControlType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityControlType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityControlType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
