// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> GitLab Group properties. </summary>
    public partial class SecurityConnectorGitLabGroupProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityConnectorGitLabGroupProperties"/>. </summary>
        public SecurityConnectorGitLabGroupProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecurityConnectorGitLabGroupProperties"/>. </summary>
        /// <param name="provisioningStatusMessage"> Gets or sets resource status message. </param>
        /// <param name="provisioningStatusUpdateTimeUtc"> Gets or sets time when resource was last checked. </param>
        /// <param name="provisioningState">
        /// The provisioning state of the resource.
        ///
        /// Pending - Provisioning pending.
        /// Failed - Provisioning failed.
        /// Succeeded - Successful provisioning.
        /// Canceled - Provisioning canceled.
        /// PendingDeletion - Deletion pending.
        /// DeletionSuccess - Deletion successful.
        /// DeletionFailure - Deletion failure.
        /// </param>
        /// <param name="fullyQualifiedName">
        /// Gets or sets the fully-qualified name of the Group object.
        ///
        /// This contains the entire namespace hierarchy where namespaces are separated by the '$' character.
        /// </param>
        /// <param name="fullyQualifiedFriendlyName">
        /// Gets or sets the human readable fully-qualified name of the Group object.
        ///
        /// This contains the entire namespace hierarchy as seen on GitLab UI where namespaces are separated by the '/' character.
        /// </param>
        /// <param name="uri"> Gets or sets the url of the GitLab Group. </param>
        /// <param name="onboardingState">
        /// Details about resource onboarding status across all connectors.
        ///
        /// OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level resources.
        /// Onboarded - this resource has already been onboarded by the specified connector.
        /// NotOnboarded - this resource has not been onboarded to any connector.
        /// NotApplicable - the onboarding state is not applicable to the current endpoint.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityConnectorGitLabGroupProperties(string provisioningStatusMessage, DateTimeOffset? provisioningStatusUpdateTimeUtc, DevOpsProvisioningState? provisioningState, string fullyQualifiedName, string fullyQualifiedFriendlyName, Uri uri, ResourceOnboardingState? onboardingState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningStatusMessage = provisioningStatusMessage;
            ProvisioningStatusUpdateTimeUtc = provisioningStatusUpdateTimeUtc;
            ProvisioningState = provisioningState;
            FullyQualifiedName = fullyQualifiedName;
            FullyQualifiedFriendlyName = fullyQualifiedFriendlyName;
            Uri = uri;
            OnboardingState = onboardingState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets resource status message. </summary>
        public string ProvisioningStatusMessage { get; }
        /// <summary> Gets or sets time when resource was last checked. </summary>
        public DateTimeOffset? ProvisioningStatusUpdateTimeUtc { get; }
        /// <summary>
        /// The provisioning state of the resource.
        ///
        /// Pending - Provisioning pending.
        /// Failed - Provisioning failed.
        /// Succeeded - Successful provisioning.
        /// Canceled - Provisioning canceled.
        /// PendingDeletion - Deletion pending.
        /// DeletionSuccess - Deletion successful.
        /// DeletionFailure - Deletion failure.
        /// </summary>
        public DevOpsProvisioningState? ProvisioningState { get; set; }
        /// <summary>
        /// Gets or sets the fully-qualified name of the Group object.
        ///
        /// This contains the entire namespace hierarchy where namespaces are separated by the '$' character.
        /// </summary>
        public string FullyQualifiedName { get; }
        /// <summary>
        /// Gets or sets the human readable fully-qualified name of the Group object.
        ///
        /// This contains the entire namespace hierarchy as seen on GitLab UI where namespaces are separated by the '/' character.
        /// </summary>
        public string FullyQualifiedFriendlyName { get; }
        /// <summary> Gets or sets the url of the GitLab Group. </summary>
        public Uri Uri { get; }
        /// <summary>
        /// Details about resource onboarding status across all connectors.
        ///
        /// OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level resources.
        /// Onboarded - this resource has already been onboarded by the specified connector.
        /// NotOnboarded - this resource has not been onboarded to any connector.
        /// NotApplicable - the onboarding state is not applicable to the current endpoint.
        /// </summary>
        public ResourceOnboardingState? OnboardingState { get; set; }
    }
}
