// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> GitHub Repository properties. </summary>
    public partial class SecurityConnectorGitHubRepositoryProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityConnectorGitHubRepositoryProperties"/>. </summary>
        public SecurityConnectorGitHubRepositoryProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecurityConnectorGitHubRepositoryProperties"/>. </summary>
        /// <param name="provisioningStatusMessage"> Gets or sets resource status message. </param>
        /// <param name="provisioningStatusUpdateTimeUtc"> Gets or sets time when resource was last checked. </param>
        /// <param name="provisioningState">
        /// The provisioning state of the resource.
        ///
        /// Pending - Provisioning pending.
        /// Failed - Provisioning failed.
        /// Succeeded - Successful provisioning.
        /// Canceled - Provisioning canceled.
        /// PendingDeletion - Deletion pending.
        /// DeletionSuccess - Deletion successful.
        /// DeletionFailure - Deletion failure.
        /// </param>
        /// <param name="repoId">
        /// Gets or sets GitHub Repository id.
        ///
        /// This is a numeric id defined by Github.
        /// Eg: "123456".
        /// </param>
        /// <param name="repoName">
        /// Gets or sets GitHub Repository name.
        /// Eg: "new-repo-1".
        /// </param>
        /// <param name="repoFullName">
        /// Gets or sets GitHub Full Name.
        /// Repository name, prefixed with Owner name.
        /// Eg: "my-org/new-repo-1".
        /// </param>
        /// <param name="onboardingState">
        /// Details about resource onboarding status across all connectors.
        ///
        /// OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level resources.
        /// Onboarded - this resource has already been onboarded by the specified connector.
        /// NotOnboarded - this resource has not been onboarded to any connector.
        /// NotApplicable - the onboarding state is not applicable to the current endpoint.
        /// </param>
        /// <param name="repoUri"> Gets or sets GitHub Repository url. </param>
        /// <param name="parentOwnerName"> Gets or sets parent GitHub Owner name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityConnectorGitHubRepositoryProperties(string provisioningStatusMessage, DateTimeOffset? provisioningStatusUpdateTimeUtc, DevOpsProvisioningState? provisioningState, string repoId, string repoName, string repoFullName, ResourceOnboardingState? onboardingState, Uri repoUri, string parentOwnerName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningStatusMessage = provisioningStatusMessage;
            ProvisioningStatusUpdateTimeUtc = provisioningStatusUpdateTimeUtc;
            ProvisioningState = provisioningState;
            RepoId = repoId;
            RepoName = repoName;
            RepoFullName = repoFullName;
            OnboardingState = onboardingState;
            RepoUri = repoUri;
            ParentOwnerName = parentOwnerName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets resource status message. </summary>
        public string ProvisioningStatusMessage { get; }
        /// <summary> Gets or sets time when resource was last checked. </summary>
        public DateTimeOffset? ProvisioningStatusUpdateTimeUtc { get; }
        /// <summary>
        /// The provisioning state of the resource.
        ///
        /// Pending - Provisioning pending.
        /// Failed - Provisioning failed.
        /// Succeeded - Successful provisioning.
        /// Canceled - Provisioning canceled.
        /// PendingDeletion - Deletion pending.
        /// DeletionSuccess - Deletion successful.
        /// DeletionFailure - Deletion failure.
        /// </summary>
        public DevOpsProvisioningState? ProvisioningState { get; set; }
        /// <summary>
        /// Gets or sets GitHub Repository id.
        ///
        /// This is a numeric id defined by Github.
        /// Eg: "123456".
        /// </summary>
        public string RepoId { get; }
        /// <summary>
        /// Gets or sets GitHub Repository name.
        /// Eg: "new-repo-1".
        /// </summary>
        public string RepoName { get; }
        /// <summary>
        /// Gets or sets GitHub Full Name.
        /// Repository name, prefixed with Owner name.
        /// Eg: "my-org/new-repo-1".
        /// </summary>
        public string RepoFullName { get; }
        /// <summary>
        /// Details about resource onboarding status across all connectors.
        ///
        /// OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level resources.
        /// Onboarded - this resource has already been onboarded by the specified connector.
        /// NotOnboarded - this resource has not been onboarded to any connector.
        /// NotApplicable - the onboarding state is not applicable to the current endpoint.
        /// </summary>
        public ResourceOnboardingState? OnboardingState { get; set; }
        /// <summary> Gets or sets GitHub Repository url. </summary>
        public Uri RepoUri { get; }
        /// <summary> Gets or sets parent GitHub Owner name. </summary>
        public string ParentOwnerName { get; set; }
    }
}
