// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> GitHub Owner properties. </summary>
    public partial class SecurityConnectorGitHubOwnerProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityConnectorGitHubOwnerProperties"/>. </summary>
        public SecurityConnectorGitHubOwnerProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecurityConnectorGitHubOwnerProperties"/>. </summary>
        /// <param name="provisioningStatusMessage"> Gets or sets resource status message. </param>
        /// <param name="provisioningStatusUpdateTimeUtc"> Gets or sets time when resource was last checked. </param>
        /// <param name="provisioningState">
        /// The provisioning state of the resource.
        ///
        /// Pending - Provisioning pending.
        /// Failed - Provisioning failed.
        /// Succeeded - Successful provisioning.
        /// Canceled - Provisioning canceled.
        /// PendingDeletion - Deletion pending.
        /// DeletionSuccess - Deletion successful.
        /// DeletionFailure - Deletion failure.
        /// </param>
        /// <param name="ownerUri"> Gets or sets GitHub Owner url. </param>
        /// <param name="gitHubInternalId"> Gets or sets internal GitHub id. </param>
        /// <param name="onboardingState">
        /// Details about resource onboarding status across all connectors.
        ///
        /// OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level resources.
        /// Onboarded - this resource has already been onboarded by the specified connector.
        /// NotOnboarded - this resource has not been onboarded to any connector.
        /// NotApplicable - the onboarding state is not applicable to the current endpoint.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityConnectorGitHubOwnerProperties(string provisioningStatusMessage, DateTimeOffset? provisioningStatusUpdateTimeUtc, DevOpsProvisioningState? provisioningState, Uri ownerUri, string gitHubInternalId, ResourceOnboardingState? onboardingState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningStatusMessage = provisioningStatusMessage;
            ProvisioningStatusUpdateTimeUtc = provisioningStatusUpdateTimeUtc;
            ProvisioningState = provisioningState;
            OwnerUri = ownerUri;
            GitHubInternalId = gitHubInternalId;
            OnboardingState = onboardingState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets resource status message. </summary>
        public string ProvisioningStatusMessage { get; }
        /// <summary> Gets or sets time when resource was last checked. </summary>
        public DateTimeOffset? ProvisioningStatusUpdateTimeUtc { get; }
        /// <summary>
        /// The provisioning state of the resource.
        ///
        /// Pending - Provisioning pending.
        /// Failed - Provisioning failed.
        /// Succeeded - Successful provisioning.
        /// Canceled - Provisioning canceled.
        /// PendingDeletion - Deletion pending.
        /// DeletionSuccess - Deletion successful.
        /// DeletionFailure - Deletion failure.
        /// </summary>
        public DevOpsProvisioningState? ProvisioningState { get; set; }
        /// <summary> Gets or sets GitHub Owner url. </summary>
        public Uri OwnerUri { get; }
        /// <summary> Gets or sets internal GitHub id. </summary>
        public string GitHubInternalId { get; }
        /// <summary>
        /// Details about resource onboarding status across all connectors.
        ///
        /// OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level resources.
        /// Onboarded - this resource has already been onboarded by the specified connector.
        /// NotOnboarded - this resource has not been onboarded to any connector.
        /// NotApplicable - the onboarding state is not applicable to the current endpoint.
        /// </summary>
        public ResourceOnboardingState? OnboardingState { get; set; }
    }
}
