// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The machine supportability of Enforce feature. </summary>
    public readonly partial struct SecurityCenterVmEnforcementSupportState : IEquatable<SecurityCenterVmEnforcementSupportState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityCenterVmEnforcementSupportState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityCenterVmEnforcementSupportState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SupportedValue = "Supported";
        private const string NotSupportedValue = "NotSupported";
        private const string UnknownValue = "Unknown";

        /// <summary> Supported. </summary>
        public static SecurityCenterVmEnforcementSupportState Supported { get; } = new SecurityCenterVmEnforcementSupportState(SupportedValue);
        /// <summary> NotSupported. </summary>
        public static SecurityCenterVmEnforcementSupportState NotSupported { get; } = new SecurityCenterVmEnforcementSupportState(NotSupportedValue);
        /// <summary> Unknown. </summary>
        public static SecurityCenterVmEnforcementSupportState Unknown { get; } = new SecurityCenterVmEnforcementSupportState(UnknownValue);
        /// <summary> Determines if two <see cref="SecurityCenterVmEnforcementSupportState"/> values are the same. </summary>
        public static bool operator ==(SecurityCenterVmEnforcementSupportState left, SecurityCenterVmEnforcementSupportState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityCenterVmEnforcementSupportState"/> values are not the same. </summary>
        public static bool operator !=(SecurityCenterVmEnforcementSupportState left, SecurityCenterVmEnforcementSupportState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityCenterVmEnforcementSupportState"/>. </summary>
        public static implicit operator SecurityCenterVmEnforcementSupportState(string value) => new SecurityCenterVmEnforcementSupportState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityCenterVmEnforcementSupportState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityCenterVmEnforcementSupportState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
