// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Represents the publisher information of a process/rule. </summary>
    public partial class SecurityCenterPublisherInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityCenterPublisherInfo"/>. </summary>
        public SecurityCenterPublisherInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecurityCenterPublisherInfo"/>. </summary>
        /// <param name="publisherName"> The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country. </param>
        /// <param name="productName"> The product name taken from the file's version resource. </param>
        /// <param name="binaryName"> The "OriginalName" field taken from the file's version resource. </param>
        /// <param name="version"> The binary file version taken from the file's version resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityCenterPublisherInfo(string publisherName, string productName, string binaryName, string version, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PublisherName = publisherName;
            ProductName = productName;
            BinaryName = binaryName;
            Version = version;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country. </summary>
        public string PublisherName { get; set; }
        /// <summary> The product name taken from the file's version resource. </summary>
        public string ProductName { get; set; }
        /// <summary> The "OriginalName" field taken from the file's version resource. </summary>
        public string BinaryName { get; set; }
        /// <summary> The binary file version taken from the file's version resource. </summary>
        public string Version { get; set; }
    }
}
