// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The pricing tier value. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features. </summary>
    public readonly partial struct SecurityCenterPricingTier : IEquatable<SecurityCenterPricingTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityCenterPricingTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityCenterPricingTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FreeValue = "Free";
        private const string StandardValue = "Standard";

        /// <summary> Get free Microsoft Defender for Cloud experience with basic security features. </summary>
        public static SecurityCenterPricingTier Free { get; } = new SecurityCenterPricingTier(FreeValue);
        /// <summary> Get the standard Microsoft Defender for Cloud experience with advanced security features. </summary>
        public static SecurityCenterPricingTier Standard { get; } = new SecurityCenterPricingTier(StandardValue);
        /// <summary> Determines if two <see cref="SecurityCenterPricingTier"/> values are the same. </summary>
        public static bool operator ==(SecurityCenterPricingTier left, SecurityCenterPricingTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityCenterPricingTier"/> values are not the same. </summary>
        public static bool operator !=(SecurityCenterPricingTier left, SecurityCenterPricingTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityCenterPricingTier"/>. </summary>
        public static implicit operator SecurityCenterPricingTier(string value) => new SecurityCenterPricingTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityCenterPricingTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityCenterPricingTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
