// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The kind of alert simulation. </summary>
    internal readonly partial struct SecurityCenterKind : IEquatable<SecurityCenterKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityCenterKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityCenterKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BundlesValue = "Bundles";

        /// <summary> Simulate alerts according to bundles. </summary>
        public static SecurityCenterKind Bundles { get; } = new SecurityCenterKind(BundlesValue);
        /// <summary> Determines if two <see cref="SecurityCenterKind"/> values are the same. </summary>
        public static bool operator ==(SecurityCenterKind left, SecurityCenterKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityCenterKind"/> values are not the same. </summary>
        public static bool operator !=(SecurityCenterKind left, SecurityCenterKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityCenterKind"/>. </summary>
        public static implicit operator SecurityCenterKind(string value) => new SecurityCenterKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityCenterKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityCenterKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
