// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux. </summary>
    public partial class SecurityCenterFileProtectionMode
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityCenterFileProtectionMode"/>. </summary>
        public SecurityCenterFileProtectionMode()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecurityCenterFileProtectionMode"/>. </summary>
        /// <param name="exe"> The application control policy enforcement/protection mode of the machine group. </param>
        /// <param name="msi"> The application control policy enforcement/protection mode of the machine group. </param>
        /// <param name="script"> The application control policy enforcement/protection mode of the machine group. </param>
        /// <param name="executable"> The application control policy enforcement/protection mode of the machine group. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityCenterFileProtectionMode(AdaptiveApplicationControlEnforcementMode? exe, AdaptiveApplicationControlEnforcementMode? msi, AdaptiveApplicationControlEnforcementMode? script, AdaptiveApplicationControlEnforcementMode? executable, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Exe = exe;
            Msi = msi;
            Script = script;
            Executable = executable;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The application control policy enforcement/protection mode of the machine group. </summary>
        public AdaptiveApplicationControlEnforcementMode? Exe { get; set; }
        /// <summary> The application control policy enforcement/protection mode of the machine group. </summary>
        public AdaptiveApplicationControlEnforcementMode? Msi { get; set; }
        /// <summary> The application control policy enforcement/protection mode of the machine group. </summary>
        public AdaptiveApplicationControlEnforcementMode? Script { get; set; }
        /// <summary> The application control policy enforcement/protection mode of the machine group. </summary>
        public AdaptiveApplicationControlEnforcementMode? Executable { get; set; }
    }
}
