// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    public partial class SecurityCenterFileProtectionMode : IUtf8JsonSerializable, IJsonModel<SecurityCenterFileProtectionMode>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SecurityCenterFileProtectionMode>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SecurityCenterFileProtectionMode>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityCenterFileProtectionMode>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityCenterFileProtectionMode)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Exe))
            {
                writer.WritePropertyName("exe"u8);
                writer.WriteStringValue(Exe.Value.ToString());
            }
            if (Optional.IsDefined(Msi))
            {
                writer.WritePropertyName("msi"u8);
                writer.WriteStringValue(Msi.Value.ToString());
            }
            if (Optional.IsDefined(Script))
            {
                writer.WritePropertyName("script"u8);
                writer.WriteStringValue(Script.Value.ToString());
            }
            if (Optional.IsDefined(Executable))
            {
                writer.WritePropertyName("executable"u8);
                writer.WriteStringValue(Executable.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SecurityCenterFileProtectionMode IJsonModel<SecurityCenterFileProtectionMode>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityCenterFileProtectionMode>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityCenterFileProtectionMode)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSecurityCenterFileProtectionMode(document.RootElement, options);
        }

        internal static SecurityCenterFileProtectionMode DeserializeSecurityCenterFileProtectionMode(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AdaptiveApplicationControlEnforcementMode? exe = default;
            AdaptiveApplicationControlEnforcementMode? msi = default;
            AdaptiveApplicationControlEnforcementMode? script = default;
            AdaptiveApplicationControlEnforcementMode? executable = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("exe"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    exe = new AdaptiveApplicationControlEnforcementMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("msi"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    msi = new AdaptiveApplicationControlEnforcementMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("script"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    script = new AdaptiveApplicationControlEnforcementMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("executable"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    executable = new AdaptiveApplicationControlEnforcementMode(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SecurityCenterFileProtectionMode(exe, msi, script, executable, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SecurityCenterFileProtectionMode>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityCenterFileProtectionMode>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SecurityCenterFileProtectionMode)} does not support writing '{options.Format}' format.");
            }
        }

        SecurityCenterFileProtectionMode IPersistableModel<SecurityCenterFileProtectionMode>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityCenterFileProtectionMode>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSecurityCenterFileProtectionMode(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SecurityCenterFileProtectionMode)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SecurityCenterFileProtectionMode>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
