// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The configuration status of the machines group or machine or rule. </summary>
    public readonly partial struct SecurityCenterConfigurationStatus : IEquatable<SecurityCenterConfigurationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityCenterConfigurationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityCenterConfigurationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConfiguredValue = "Configured";
        private const string NotConfiguredValue = "NotConfigured";
        private const string InProgressValue = "InProgress";
        private const string FailedValue = "Failed";
        private const string NoStatusValue = "NoStatus";

        /// <summary> Configured. </summary>
        public static SecurityCenterConfigurationStatus Configured { get; } = new SecurityCenterConfigurationStatus(ConfiguredValue);
        /// <summary> NotConfigured. </summary>
        public static SecurityCenterConfigurationStatus NotConfigured { get; } = new SecurityCenterConfigurationStatus(NotConfiguredValue);
        /// <summary> InProgress. </summary>
        public static SecurityCenterConfigurationStatus InProgress { get; } = new SecurityCenterConfigurationStatus(InProgressValue);
        /// <summary> Failed. </summary>
        public static SecurityCenterConfigurationStatus Failed { get; } = new SecurityCenterConfigurationStatus(FailedValue);
        /// <summary> NoStatus. </summary>
        public static SecurityCenterConfigurationStatus NoStatus { get; } = new SecurityCenterConfigurationStatus(NoStatusValue);
        /// <summary> Determines if two <see cref="SecurityCenterConfigurationStatus"/> values are the same. </summary>
        public static bool operator ==(SecurityCenterConfigurationStatus left, SecurityCenterConfigurationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityCenterConfigurationStatus"/> values are not the same. </summary>
        public static bool operator !=(SecurityCenterConfigurationStatus left, SecurityCenterConfigurationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityCenterConfigurationStatus"/>. </summary>
        public static implicit operator SecurityCenterConfigurationStatus(string value) => new SecurityCenterConfigurationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityCenterConfigurationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityCenterConfigurationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
