// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> A permission detected in the cloud account. </summary>
    public readonly partial struct SecurityCenterCloudPermission : IEquatable<SecurityCenterCloudPermission>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityCenterCloudPermission"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityCenterCloudPermission(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AwsAwsSecurityHubReadOnlyAccessValue = "AWS::AWSSecurityHubReadOnlyAccess";
        private const string AwsSecurityAuditValue = "AWS::SecurityAudit";
        private const string AwsAmazonSsmAutomationRoleValue = "AWS::AmazonSSMAutomationRole";
        private const string GcpSecurityCenterAdminViewerValue = "GCP::Security Center Admin Viewer";

        /// <summary> This permission provides read only access to AWS Security Hub resources. </summary>
        public static SecurityCenterCloudPermission AwsAwsSecurityHubReadOnlyAccess { get; } = new SecurityCenterCloudPermission(AwsAwsSecurityHubReadOnlyAccessValue);
        /// <summary> This permission grants access to read security configuration metadata. </summary>
        public static SecurityCenterCloudPermission AwsSecurityAudit { get; } = new SecurityCenterCloudPermission(AwsSecurityAuditValue);
        /// <summary> The permission provides for EC2 Automation service to execute activities defined within Automation documents. </summary>
        public static SecurityCenterCloudPermission AwsAmazonSsmAutomationRole { get; } = new SecurityCenterCloudPermission(AwsAmazonSsmAutomationRoleValue);
        /// <summary> This permission provides read only access to GCP Security Command Center. </summary>
        public static SecurityCenterCloudPermission GcpSecurityCenterAdminViewer { get; } = new SecurityCenterCloudPermission(GcpSecurityCenterAdminViewerValue);
        /// <summary> Determines if two <see cref="SecurityCenterCloudPermission"/> values are the same. </summary>
        public static bool operator ==(SecurityCenterCloudPermission left, SecurityCenterCloudPermission right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityCenterCloudPermission"/> values are not the same. </summary>
        public static bool operator !=(SecurityCenterCloudPermission left, SecurityCenterCloudPermission right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityCenterCloudPermission"/>. </summary>
        public static implicit operator SecurityCenterCloudPermission(string value) => new SecurityCenterCloudPermission(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityCenterCloudPermission other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityCenterCloudPermission other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
