// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The multi cloud resource's cloud name. </summary>
    public readonly partial struct SecurityCenterCloudName : IEquatable<SecurityCenterCloudName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityCenterCloudName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityCenterCloudName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureValue = "Azure";
        private const string AwsValue = "AWS";
        private const string GcpValue = "GCP";
        private const string GithubValue = "Github";
        private const string AzureDevOpsValue = "AzureDevOps";
        private const string GitLabValue = "GitLab";

        /// <summary> Azure. </summary>
        public static SecurityCenterCloudName Azure { get; } = new SecurityCenterCloudName(AzureValue);
        /// <summary> AWS. </summary>
        public static SecurityCenterCloudName Aws { get; } = new SecurityCenterCloudName(AwsValue);
        /// <summary> GCP. </summary>
        public static SecurityCenterCloudName Gcp { get; } = new SecurityCenterCloudName(GcpValue);
        /// <summary> Github. </summary>
        public static SecurityCenterCloudName Github { get; } = new SecurityCenterCloudName(GithubValue);
        /// <summary> AzureDevOps. </summary>
        public static SecurityCenterCloudName AzureDevOps { get; } = new SecurityCenterCloudName(AzureDevOpsValue);
        /// <summary> GitLab. </summary>
        public static SecurityCenterCloudName GitLab { get; } = new SecurityCenterCloudName(GitLabValue);
        /// <summary> Determines if two <see cref="SecurityCenterCloudName"/> values are the same. </summary>
        public static bool operator ==(SecurityCenterCloudName left, SecurityCenterCloudName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityCenterCloudName"/> values are not the same. </summary>
        public static bool operator !=(SecurityCenterCloudName left, SecurityCenterCloudName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityCenterCloudName"/>. </summary>
        public static implicit operator SecurityCenterCloudName(string value) => new SecurityCenterCloudName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityCenterCloudName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityCenterCloudName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
