// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    public partial class SecurityAutomationTriggeringRule : IUtf8JsonSerializable, IJsonModel<SecurityAutomationTriggeringRule>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SecurityAutomationTriggeringRule>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SecurityAutomationTriggeringRule>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityAutomationTriggeringRule>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityAutomationTriggeringRule)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(PropertyJPath))
            {
                writer.WritePropertyName("propertyJPath"u8);
                writer.WriteStringValue(PropertyJPath);
            }
            if (Optional.IsDefined(PropertyType))
            {
                writer.WritePropertyName("propertyType"u8);
                writer.WriteStringValue(PropertyType.Value.ToString());
            }
            if (Optional.IsDefined(ExpectedValue))
            {
                writer.WritePropertyName("expectedValue"u8);
                writer.WriteStringValue(ExpectedValue);
            }
            if (Optional.IsDefined(Operator))
            {
                writer.WritePropertyName("operator"u8);
                writer.WriteStringValue(Operator.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SecurityAutomationTriggeringRule IJsonModel<SecurityAutomationTriggeringRule>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityAutomationTriggeringRule>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityAutomationTriggeringRule)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSecurityAutomationTriggeringRule(document.RootElement, options);
        }

        internal static SecurityAutomationTriggeringRule DeserializeSecurityAutomationTriggeringRule(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string propertyJPath = default;
            AutomationTriggeringRulePropertyType? propertyType = default;
            string expectedValue = default;
            AutomationTriggeringRuleOperator? @operator = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("propertyJPath"u8))
                {
                    propertyJPath = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("propertyType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    propertyType = new AutomationTriggeringRulePropertyType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("expectedValue"u8))
                {
                    expectedValue = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("operator"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    @operator = new AutomationTriggeringRuleOperator(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SecurityAutomationTriggeringRule(propertyJPath, propertyType, expectedValue, @operator, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SecurityAutomationTriggeringRule>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityAutomationTriggeringRule>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SecurityAutomationTriggeringRule)} does not support writing '{options.Format}' format.");
            }
        }

        SecurityAutomationTriggeringRule IPersistableModel<SecurityAutomationTriggeringRule>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityAutomationTriggeringRule>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSecurityAutomationTriggeringRule(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SecurityAutomationTriggeringRule)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SecurityAutomationTriggeringRule>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
