// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The user impact of the assessment. </summary>
    public readonly partial struct SecurityAssessmentUserImpact : IEquatable<SecurityAssessmentUserImpact>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityAssessmentUserImpact"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityAssessmentUserImpact(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "Low";
        private const string ModerateValue = "Moderate";
        private const string HighValue = "High";

        /// <summary> Low. </summary>
        public static SecurityAssessmentUserImpact Low { get; } = new SecurityAssessmentUserImpact(LowValue);
        /// <summary> Moderate. </summary>
        public static SecurityAssessmentUserImpact Moderate { get; } = new SecurityAssessmentUserImpact(ModerateValue);
        /// <summary> High. </summary>
        public static SecurityAssessmentUserImpact High { get; } = new SecurityAssessmentUserImpact(HighValue);
        /// <summary> Determines if two <see cref="SecurityAssessmentUserImpact"/> values are the same. </summary>
        public static bool operator ==(SecurityAssessmentUserImpact left, SecurityAssessmentUserImpact right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityAssessmentUserImpact"/> values are not the same. </summary>
        public static bool operator !=(SecurityAssessmentUserImpact left, SecurityAssessmentUserImpact right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityAssessmentUserImpact"/>. </summary>
        public static implicit operator SecurityAssessmentUserImpact(string value) => new SecurityAssessmentUserImpact(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityAssessmentUserImpact other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityAssessmentUserImpact other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
