// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition. </summary>
    public readonly partial struct SecurityAssessmentType : IEquatable<SecurityAssessmentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityAssessmentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityAssessmentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BuiltInValue = "BuiltIn";
        private const string CustomPolicyValue = "CustomPolicy";
        private const string CustomerManagedValue = "CustomerManaged";
        private const string VerifiedPartnerValue = "VerifiedPartner";

        /// <summary> Microsoft Defender for Cloud managed assessments. </summary>
        public static SecurityAssessmentType BuiltIn { get; } = new SecurityAssessmentType(BuiltInValue);
        /// <summary> User defined policies that are automatically ingested from Azure Policy to Microsoft Defender for Cloud. </summary>
        public static SecurityAssessmentType CustomPolicy { get; } = new SecurityAssessmentType(CustomPolicyValue);
        /// <summary> User assessments pushed directly by the user or other third party to Microsoft Defender for Cloud. </summary>
        public static SecurityAssessmentType CustomerManaged { get; } = new SecurityAssessmentType(CustomerManagedValue);
        /// <summary> An assessment that was created by a verified 3rd party if the user connected it to ASC. </summary>
        public static SecurityAssessmentType VerifiedPartner { get; } = new SecurityAssessmentType(VerifiedPartnerValue);
        /// <summary> Determines if two <see cref="SecurityAssessmentType"/> values are the same. </summary>
        public static bool operator ==(SecurityAssessmentType left, SecurityAssessmentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityAssessmentType"/> values are not the same. </summary>
        public static bool operator !=(SecurityAssessmentType left, SecurityAssessmentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityAssessmentType"/>. </summary>
        public static implicit operator SecurityAssessmentType(string value) => new SecurityAssessmentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityAssessmentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityAssessmentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
