// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Programmatic code for the status of the assessment. </summary>
    public readonly partial struct SecurityAssessmentStatusCode : IEquatable<SecurityAssessmentStatusCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityAssessmentStatusCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityAssessmentStatusCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HealthyValue = "Healthy";
        private const string UnhealthyValue = "Unhealthy";
        private const string NotApplicableValue = "NotApplicable";

        /// <summary> The resource is healthy. </summary>
        public static SecurityAssessmentStatusCode Healthy { get; } = new SecurityAssessmentStatusCode(HealthyValue);
        /// <summary> The resource has a security issue that needs to be addressed. </summary>
        public static SecurityAssessmentStatusCode Unhealthy { get; } = new SecurityAssessmentStatusCode(UnhealthyValue);
        /// <summary> Assessment for this resource did not happen. </summary>
        public static SecurityAssessmentStatusCode NotApplicable { get; } = new SecurityAssessmentStatusCode(NotApplicableValue);
        /// <summary> Determines if two <see cref="SecurityAssessmentStatusCode"/> values are the same. </summary>
        public static bool operator ==(SecurityAssessmentStatusCode left, SecurityAssessmentStatusCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityAssessmentStatusCode"/> values are not the same. </summary>
        public static bool operator !=(SecurityAssessmentStatusCode left, SecurityAssessmentStatusCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityAssessmentStatusCode"/>. </summary>
        public static implicit operator SecurityAssessmentStatusCode(string value) => new SecurityAssessmentStatusCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityAssessmentStatusCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityAssessmentStatusCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
