// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The sub-assessment severity level. </summary>
    public readonly partial struct SecurityAssessmentSeverity : IEquatable<SecurityAssessmentSeverity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityAssessmentSeverity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityAssessmentSeverity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "Low";
        private const string MediumValue = "Medium";
        private const string HighValue = "High";

        /// <summary> Low. </summary>
        public static SecurityAssessmentSeverity Low { get; } = new SecurityAssessmentSeverity(LowValue);
        /// <summary> Medium. </summary>
        public static SecurityAssessmentSeverity Medium { get; } = new SecurityAssessmentSeverity(MediumValue);
        /// <summary> High. </summary>
        public static SecurityAssessmentSeverity High { get; } = new SecurityAssessmentSeverity(HighValue);
        /// <summary> Determines if two <see cref="SecurityAssessmentSeverity"/> values are the same. </summary>
        public static bool operator ==(SecurityAssessmentSeverity left, SecurityAssessmentSeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityAssessmentSeverity"/> values are not the same. </summary>
        public static bool operator !=(SecurityAssessmentSeverity left, SecurityAssessmentSeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityAssessmentSeverity"/>. </summary>
        public static implicit operator SecurityAssessmentSeverity(string value) => new SecurityAssessmentSeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityAssessmentSeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityAssessmentSeverity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
