// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Describes properties of an assessment metadata. </summary>
    public partial class SecurityAssessmentMetadataProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityAssessmentMetadataProperties"/>. </summary>
        /// <param name="displayName"> User friendly display name of the assessment. </param>
        /// <param name="severity"> The severity level of the assessment. </param>
        /// <param name="assessmentType"> BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="displayName"/> is null. </exception>
        public SecurityAssessmentMetadataProperties(string displayName, SecurityAssessmentSeverity severity, SecurityAssessmentType assessmentType)
        {
            Argument.AssertNotNull(displayName, nameof(displayName));

            DisplayName = displayName;
            Categories = new ChangeTrackingList<SecurityAssessmentResourceCategory>();
            Severity = severity;
            Threats = new ChangeTrackingList<SecurityThreat>();
            AssessmentType = assessmentType;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityAssessmentMetadataProperties"/>. </summary>
        /// <param name="displayName"> User friendly display name of the assessment. </param>
        /// <param name="policyDefinitionId"> Azure resource ID of the policy definition that turns this assessment calculation on. </param>
        /// <param name="description"> Human readable description of the assessment. </param>
        /// <param name="remediationDescription"> Human readable description of what you should do to mitigate this security issue. </param>
        /// <param name="categories"></param>
        /// <param name="severity"> The severity level of the assessment. </param>
        /// <param name="userImpact"> The user impact of the assessment. </param>
        /// <param name="implementationEffort"> The implementation effort required to remediate this assessment. </param>
        /// <param name="threats"></param>
        /// <param name="isPreview"> True if this assessment is in preview release status. </param>
        /// <param name="assessmentType"> BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition. </param>
        /// <param name="partnerData"> Describes the partner that created the assessment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityAssessmentMetadataProperties(string displayName, ResourceIdentifier policyDefinitionId, string description, string remediationDescription, IList<SecurityAssessmentResourceCategory> categories, SecurityAssessmentSeverity severity, SecurityAssessmentUserImpact? userImpact, ImplementationEffort? implementationEffort, IList<SecurityThreat> threats, bool? isPreview, SecurityAssessmentType assessmentType, SecurityAssessmentMetadataPartner partnerData, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DisplayName = displayName;
            PolicyDefinitionId = policyDefinitionId;
            Description = description;
            RemediationDescription = remediationDescription;
            Categories = categories;
            Severity = severity;
            UserImpact = userImpact;
            ImplementationEffort = implementationEffort;
            Threats = threats;
            IsPreview = isPreview;
            AssessmentType = assessmentType;
            PartnerData = partnerData;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityAssessmentMetadataProperties"/> for deserialization. </summary>
        internal SecurityAssessmentMetadataProperties()
        {
        }

        /// <summary> User friendly display name of the assessment. </summary>
        public string DisplayName { get; set; }
        /// <summary> Azure resource ID of the policy definition that turns this assessment calculation on. </summary>
        public ResourceIdentifier PolicyDefinitionId { get; }
        /// <summary> Human readable description of the assessment. </summary>
        public string Description { get; set; }
        /// <summary> Human readable description of what you should do to mitigate this security issue. </summary>
        public string RemediationDescription { get; set; }
        /// <summary> Gets the categories. </summary>
        public IList<SecurityAssessmentResourceCategory> Categories { get; }
        /// <summary> The severity level of the assessment. </summary>
        public SecurityAssessmentSeverity Severity { get; set; }
        /// <summary> The user impact of the assessment. </summary>
        public SecurityAssessmentUserImpact? UserImpact { get; set; }
        /// <summary> The implementation effort required to remediate this assessment. </summary>
        public ImplementationEffort? ImplementationEffort { get; set; }
        /// <summary> Gets the threats. </summary>
        public IList<SecurityThreat> Threats { get; }
        /// <summary> True if this assessment is in preview release status. </summary>
        public bool? IsPreview { get; set; }
        /// <summary> BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition. </summary>
        public SecurityAssessmentType AssessmentType { get; set; }
        /// <summary> Describes the partner that created the assessment. </summary>
        public SecurityAssessmentMetadataPartner PartnerData { get; set; }
    }
}
