// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Simulate alerts according to this bundles. </summary>
    public partial class SecurityAlertSimulatorBundlesRequestProperties : SecurityAlertSimulatorRequestProperties
    {
        /// <summary> Initializes a new instance of <see cref="SecurityAlertSimulatorBundlesRequestProperties"/>. </summary>
        public SecurityAlertSimulatorBundlesRequestProperties()
        {
            Bundles = new ChangeTrackingList<SecurityAlertSimulatorBundleType>();
            Kind = SecurityCenterKind.Bundles;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityAlertSimulatorBundlesRequestProperties"/>. </summary>
        /// <param name="kind"> The kind of alert simulation. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="bundles"> Bundles list. </param>
        internal SecurityAlertSimulatorBundlesRequestProperties(SecurityCenterKind kind, IDictionary<string, BinaryData> additionalProperties, IList<SecurityAlertSimulatorBundleType> bundles) : base(kind, additionalProperties)
        {
            Bundles = bundles;
            Kind = kind;
        }

        /// <summary> Bundles list. </summary>
        public IList<SecurityAlertSimulatorBundleType> Bundles { get; }
    }
}
