// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> A possible role to configure sending security notification alerts to. </summary>
    public readonly partial struct SecurityAlertReceivingRole : IEquatable<SecurityAlertReceivingRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityAlertReceivingRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityAlertReceivingRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AccountAdminValue = "AccountAdmin";
        private const string ServiceAdminValue = "ServiceAdmin";
        private const string OwnerValue = "Owner";
        private const string ContributorValue = "Contributor";

        /// <summary> If enabled, send notification on new alerts to the account admins. </summary>
        public static SecurityAlertReceivingRole AccountAdmin { get; } = new SecurityAlertReceivingRole(AccountAdminValue);
        /// <summary> If enabled, send notification on new alerts to the service admins. </summary>
        public static SecurityAlertReceivingRole ServiceAdmin { get; } = new SecurityAlertReceivingRole(ServiceAdminValue);
        /// <summary> If enabled, send notification on new alerts to the subscription owners. </summary>
        public static SecurityAlertReceivingRole Owner { get; } = new SecurityAlertReceivingRole(OwnerValue);
        /// <summary> If enabled, send notification on new alerts to the subscription contributors. </summary>
        public static SecurityAlertReceivingRole Contributor { get; } = new SecurityAlertReceivingRole(ContributorValue);
        /// <summary> Determines if two <see cref="SecurityAlertReceivingRole"/> values are the same. </summary>
        public static bool operator ==(SecurityAlertReceivingRole left, SecurityAlertReceivingRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityAlertReceivingRole"/> values are not the same. </summary>
        public static bool operator !=(SecurityAlertReceivingRole left, SecurityAlertReceivingRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityAlertReceivingRole"/>. </summary>
        public static implicit operator SecurityAlertReceivingRole(string value) => new SecurityAlertReceivingRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityAlertReceivingRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityAlertReceivingRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
