// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Defines if email notifications will be sent about new security alerts. </summary>
    public readonly partial struct SecurityAlertNotificationState : IEquatable<SecurityAlertNotificationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityAlertNotificationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityAlertNotificationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnValue = "On";
        private const string OffValue = "Off";

        /// <summary> Get notifications on new alerts. </summary>
        public static SecurityAlertNotificationState On { get; } = new SecurityAlertNotificationState(OnValue);
        /// <summary> Don't get notifications on new alerts. </summary>
        public static SecurityAlertNotificationState Off { get; } = new SecurityAlertNotificationState(OffValue);
        /// <summary> Determines if two <see cref="SecurityAlertNotificationState"/> values are the same. </summary>
        public static bool operator ==(SecurityAlertNotificationState left, SecurityAlertNotificationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityAlertNotificationState"/> values are not the same. </summary>
        public static bool operator !=(SecurityAlertNotificationState left, SecurityAlertNotificationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityAlertNotificationState"/>. </summary>
        public static implicit operator SecurityAlertNotificationState(string value) => new SecurityAlertNotificationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityAlertNotificationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityAlertNotificationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
