// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the subscription. </summary>
    public readonly partial struct SecurityAlertNotificationByRoleState : IEquatable<SecurityAlertNotificationByRoleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityAlertNotificationByRoleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityAlertNotificationByRoleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnValue = "On";
        private const string OffValue = "Off";

        /// <summary> Send notification on new alerts to the subscription's admins. </summary>
        public static SecurityAlertNotificationByRoleState On { get; } = new SecurityAlertNotificationByRoleState(OnValue);
        /// <summary> Don't send notification on new alerts to the subscription's admins. </summary>
        public static SecurityAlertNotificationByRoleState Off { get; } = new SecurityAlertNotificationByRoleState(OffValue);
        /// <summary> Determines if two <see cref="SecurityAlertNotificationByRoleState"/> values are the same. </summary>
        public static bool operator ==(SecurityAlertNotificationByRoleState left, SecurityAlertNotificationByRoleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityAlertNotificationByRoleState"/> values are not the same. </summary>
        public static bool operator !=(SecurityAlertNotificationByRoleState left, SecurityAlertNotificationByRoleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityAlertNotificationByRoleState"/>. </summary>
        public static implicit operator SecurityAlertNotificationByRoleState(string value) => new SecurityAlertNotificationByRoleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityAlertNotificationByRoleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityAlertNotificationByRoleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
