// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The rule severity. </summary>
    public readonly partial struct RuleSeverity : IEquatable<RuleSeverity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RuleSeverity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RuleSeverity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HighValue = "High";
        private const string MediumValue = "Medium";
        private const string LowValue = "Low";
        private const string InformationalValue = "Informational";
        private const string ObsoleteValue = "Obsolete";

        /// <summary> High. </summary>
        public static RuleSeverity High { get; } = new RuleSeverity(HighValue);
        /// <summary> Medium. </summary>
        public static RuleSeverity Medium { get; } = new RuleSeverity(MediumValue);
        /// <summary> Low. </summary>
        public static RuleSeverity Low { get; } = new RuleSeverity(LowValue);
        /// <summary> Informational. </summary>
        public static RuleSeverity Informational { get; } = new RuleSeverity(InformationalValue);
        /// <summary> Obsolete. </summary>
        public static RuleSeverity Obsolete { get; } = new RuleSeverity(ObsoleteValue);
        /// <summary> Determines if two <see cref="RuleSeverity"/> values are the same. </summary>
        public static bool operator ==(RuleSeverity left, RuleSeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RuleSeverity"/> values are not the same. </summary>
        public static bool operator !=(RuleSeverity left, RuleSeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RuleSeverity"/>. </summary>
        public static implicit operator RuleSeverity(string value) => new RuleSeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RuleSeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RuleSeverity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
