// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary>
    /// Rule categories.
    /// Code - code scanning results.
    /// Artifact scanning results.
    /// Dependencies scanning results.
    /// IaC results.
    /// Secrets scanning results.
    /// Container scanning results.
    /// </summary>
    public readonly partial struct RuleCategory : IEquatable<RuleCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RuleCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RuleCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CodeValue = "Code";
        private const string ArtifactsValue = "Artifacts";
        private const string DependenciesValue = "Dependencies";
        private const string SecretsValue = "Secrets";
        private const string IaCValue = "IaC";
        private const string ContainersValue = "Containers";

        /// <summary> Code. </summary>
        public static RuleCategory Code { get; } = new RuleCategory(CodeValue);
        /// <summary> Artifacts. </summary>
        public static RuleCategory Artifacts { get; } = new RuleCategory(ArtifactsValue);
        /// <summary> Dependencies. </summary>
        public static RuleCategory Dependencies { get; } = new RuleCategory(DependenciesValue);
        /// <summary> Secrets. </summary>
        public static RuleCategory Secrets { get; } = new RuleCategory(SecretsValue);
        /// <summary> IaC. </summary>
        public static RuleCategory IaC { get; } = new RuleCategory(IaCValue);
        /// <summary> Containers. </summary>
        public static RuleCategory Containers { get; } = new RuleCategory(ContainersValue);
        /// <summary> Determines if two <see cref="RuleCategory"/> values are the same. </summary>
        public static bool operator ==(RuleCategory left, RuleCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RuleCategory"/> values are not the same. </summary>
        public static bool operator !=(RuleCategory left, RuleCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RuleCategory"/>. </summary>
        public static implicit operator RuleCategory(string value) => new RuleCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RuleCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RuleCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
