// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary>
    /// Details about resource onboarding status across all connectors.
    ///
    /// OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level resources.
    /// Onboarded - this resource has already been onboarded by the specified connector.
    /// NotOnboarded - this resource has not been onboarded to any connector.
    /// NotApplicable - the onboarding state is not applicable to the current endpoint.
    /// </summary>
    public readonly partial struct ResourceOnboardingState : IEquatable<ResourceOnboardingState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceOnboardingState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceOnboardingState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotApplicableValue = "NotApplicable";
        private const string OnboardedByOtherConnectorValue = "OnboardedByOtherConnector";
        private const string OnboardedValue = "Onboarded";
        private const string NotOnboardedValue = "NotOnboarded";

        /// <summary> NotApplicable. </summary>
        public static ResourceOnboardingState NotApplicable { get; } = new ResourceOnboardingState(NotApplicableValue);
        /// <summary> OnboardedByOtherConnector. </summary>
        public static ResourceOnboardingState OnboardedByOtherConnector { get; } = new ResourceOnboardingState(OnboardedByOtherConnectorValue);
        /// <summary> Onboarded. </summary>
        public static ResourceOnboardingState Onboarded { get; } = new ResourceOnboardingState(OnboardedValue);
        /// <summary> NotOnboarded. </summary>
        public static ResourceOnboardingState NotOnboarded { get; } = new ResourceOnboardingState(NotOnboardedValue);
        /// <summary> Determines if two <see cref="ResourceOnboardingState"/> values are the same. </summary>
        public static bool operator ==(ResourceOnboardingState left, ResourceOnboardingState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceOnboardingState"/> values are not the same. </summary>
        public static bool operator !=(ResourceOnboardingState left, ResourceOnboardingState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceOnboardingState"/>. </summary>
        public static implicit operator ResourceOnboardingState(string value) => new ResourceOnboardingState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceOnboardingState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceOnboardingState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
