// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> There can be multiple identifiers of different type per alert, this field specify the identifier type. </summary>
    internal readonly partial struct ResourceIdentifierType : IEquatable<ResourceIdentifierType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceIdentifierType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceIdentifierType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureResourceValue = "AzureResource";
        private const string LogAnalyticsValue = "LogAnalytics";

        /// <summary> AzureResource. </summary>
        public static ResourceIdentifierType AzureResource { get; } = new ResourceIdentifierType(AzureResourceValue);
        /// <summary> LogAnalytics. </summary>
        public static ResourceIdentifierType LogAnalytics { get; } = new ResourceIdentifierType(LogAnalyticsValue);
        /// <summary> Determines if two <see cref="ResourceIdentifierType"/> values are the same. </summary>
        public static bool operator ==(ResourceIdentifierType left, ResourceIdentifierType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceIdentifierType"/> values are not the same. </summary>
        public static bool operator !=(ResourceIdentifierType left, ResourceIdentifierType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceIdentifierType"/>. </summary>
        public static implicit operator ResourceIdentifierType(string value) => new ResourceIdentifierType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceIdentifierType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceIdentifierType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
