// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Aggregative state based on the standard's supported controls states. </summary>
    public readonly partial struct RegulatoryComplianceState : IEquatable<RegulatoryComplianceState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RegulatoryComplianceState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RegulatoryComplianceState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PassedValue = "Passed";
        private const string FailedValue = "Failed";
        private const string SkippedValue = "Skipped";
        private const string UnsupportedValue = "Unsupported";

        /// <summary> All supported regulatory compliance controls in the given standard have a passed state. </summary>
        public static RegulatoryComplianceState Passed { get; } = new RegulatoryComplianceState(PassedValue);
        /// <summary> At least one supported regulatory compliance control in the given standard has a state of failed. </summary>
        public static RegulatoryComplianceState Failed { get; } = new RegulatoryComplianceState(FailedValue);
        /// <summary> All supported regulatory compliance controls in the given standard have a state of skipped. </summary>
        public static RegulatoryComplianceState Skipped { get; } = new RegulatoryComplianceState(SkippedValue);
        /// <summary> No supported regulatory compliance data for the given standard. </summary>
        public static RegulatoryComplianceState Unsupported { get; } = new RegulatoryComplianceState(UnsupportedValue);
        /// <summary> Determines if two <see cref="RegulatoryComplianceState"/> values are the same. </summary>
        public static bool operator ==(RegulatoryComplianceState left, RegulatoryComplianceState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RegulatoryComplianceState"/> values are not the same. </summary>
        public static bool operator !=(RegulatoryComplianceState left, RegulatoryComplianceState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RegulatoryComplianceState"/>. </summary>
        public static implicit operator RegulatoryComplianceState(string value) => new RegulatoryComplianceState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RegulatoryComplianceState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RegulatoryComplianceState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
