// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The initial recommendation status of the machine group or machine. </summary>
    public readonly partial struct RecommendationStatus : IEquatable<RecommendationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecommendationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecommendationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RecommendedValue = "Recommended";
        private const string NotRecommendedValue = "NotRecommended";
        private const string NotAvailableValue = "NotAvailable";
        private const string NoStatusValue = "NoStatus";

        /// <summary> Recommended. </summary>
        public static RecommendationStatus Recommended { get; } = new RecommendationStatus(RecommendedValue);
        /// <summary> NotRecommended. </summary>
        public static RecommendationStatus NotRecommended { get; } = new RecommendationStatus(NotRecommendedValue);
        /// <summary> NotAvailable. </summary>
        public static RecommendationStatus NotAvailable { get; } = new RecommendationStatus(NotAvailableValue);
        /// <summary> NoStatus. </summary>
        public static RecommendationStatus NoStatus { get; } = new RecommendationStatus(NoStatusValue);
        /// <summary> Determines if two <see cref="RecommendationStatus"/> values are the same. </summary>
        public static bool operator ==(RecommendationStatus left, RecommendationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecommendationStatus"/> values are not the same. </summary>
        public static bool operator !=(RecommendationStatus left, RecommendationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecommendationStatus"/>. </summary>
        public static implicit operator RecommendationStatus(string value) => new RecommendationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecommendationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecommendationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
