// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The type of the file (for Linux files - Executable is used). </summary>
    public readonly partial struct PathRecommendationFileType : IEquatable<PathRecommendationFileType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PathRecommendationFileType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PathRecommendationFileType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ExeValue = "Exe";
        private const string DllValue = "Dll";
        private const string MsiValue = "Msi";
        private const string ScriptValue = "Script";
        private const string ExecutableValue = "Executable";
        private const string UnknownValue = "Unknown";

        /// <summary> Exe. </summary>
        public static PathRecommendationFileType Exe { get; } = new PathRecommendationFileType(ExeValue);
        /// <summary> Dll. </summary>
        public static PathRecommendationFileType Dll { get; } = new PathRecommendationFileType(DllValue);
        /// <summary> Msi. </summary>
        public static PathRecommendationFileType Msi { get; } = new PathRecommendationFileType(MsiValue);
        /// <summary> Script. </summary>
        public static PathRecommendationFileType Script { get; } = new PathRecommendationFileType(ScriptValue);
        /// <summary> Executable. </summary>
        public static PathRecommendationFileType Executable { get; } = new PathRecommendationFileType(ExecutableValue);
        /// <summary> Unknown. </summary>
        public static PathRecommendationFileType Unknown { get; } = new PathRecommendationFileType(UnknownValue);
        /// <summary> Determines if two <see cref="PathRecommendationFileType"/> values are the same. </summary>
        public static bool operator ==(PathRecommendationFileType left, PathRecommendationFileType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PathRecommendationFileType"/> values are not the same. </summary>
        public static bool operator !=(PathRecommendationFileType left, PathRecommendationFileType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PathRecommendationFileType"/>. </summary>
        public static implicit operator PathRecommendationFileType(string value) => new PathRecommendationFileType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PathRecommendationFileType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PathRecommendationFileType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
