// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The multi cloud account's membership type in the organization. </summary>
    internal readonly partial struct OrganizationMembershipType : IEquatable<OrganizationMembershipType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OrganizationMembershipType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OrganizationMembershipType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MemberValue = "Member";
        private const string OrganizationValue = "Organization";

        /// <summary> Member. </summary>
        public static OrganizationMembershipType Member { get; } = new OrganizationMembershipType(MemberValue);
        /// <summary> Organization. </summary>
        public static OrganizationMembershipType Organization { get; } = new OrganizationMembershipType(OrganizationValue);
        /// <summary> Determines if two <see cref="OrganizationMembershipType"/> values are the same. </summary>
        public static bool operator ==(OrganizationMembershipType left, OrganizationMembershipType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OrganizationMembershipType"/> values are not the same. </summary>
        public static bool operator !=(OrganizationMembershipType left, OrganizationMembershipType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OrganizationMembershipType"/>. </summary>
        public static implicit operator OrganizationMembershipType(string value) => new OrganizationMembershipType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OrganizationMembershipType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OrganizationMembershipType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
