// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Microsoft information protection integration status. </summary>
    public readonly partial struct MipIntegrationStatus : IEquatable<MipIntegrationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MipIntegrationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MipIntegrationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OkValue = "Ok";
        private const string NoConsentValue = "noConsent";
        private const string NoAutoLabelingRulesValue = "noAutoLabelingRules";
        private const string NoMipLabelsValue = "noMipLabels";

        /// <summary> Ok. </summary>
        public static MipIntegrationStatus Ok { get; } = new MipIntegrationStatus(OkValue);
        /// <summary> noConsent. </summary>
        public static MipIntegrationStatus NoConsent { get; } = new MipIntegrationStatus(NoConsentValue);
        /// <summary> noAutoLabelingRules. </summary>
        public static MipIntegrationStatus NoAutoLabelingRules { get; } = new MipIntegrationStatus(NoAutoLabelingRulesValue);
        /// <summary> noMipLabels. </summary>
        public static MipIntegrationStatus NoMipLabels { get; } = new MipIntegrationStatus(NoMipLabelsValue);
        /// <summary> Determines if two <see cref="MipIntegrationStatus"/> values are the same. </summary>
        public static bool operator ==(MipIntegrationStatus left, MipIntegrationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MipIntegrationStatus"/> values are not the same. </summary>
        public static bool operator !=(MipIntegrationStatus left, MipIntegrationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MipIntegrationStatus"/>. </summary>
        public static implicit operator MipIntegrationStatus(string value) => new MipIntegrationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MipIntegrationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MipIntegrationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
