// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    public partial class LogAnalyticsIdentifier : IUtf8JsonSerializable, IJsonModel<LogAnalyticsIdentifier>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LogAnalyticsIdentifier>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LogAnalyticsIdentifier>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LogAnalyticsIdentifier>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LogAnalyticsIdentifier)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(WorkspaceId))
            {
                writer.WritePropertyName("workspaceId"u8);
                writer.WriteStringValue(WorkspaceId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(WorkspaceSubscriptionId))
            {
                writer.WritePropertyName("workspaceSubscriptionId"u8);
                writer.WriteStringValue(WorkspaceSubscriptionId);
            }
            if (options.Format != "W" && Optional.IsDefined(WorkspaceResourceGroup))
            {
                writer.WritePropertyName("workspaceResourceGroup"u8);
                writer.WriteStringValue(WorkspaceResourceGroup);
            }
            if (options.Format != "W" && Optional.IsDefined(AgentId))
            {
                writer.WritePropertyName("agentId"u8);
                writer.WriteStringValue(AgentId.Value);
            }
        }

        LogAnalyticsIdentifier IJsonModel<LogAnalyticsIdentifier>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LogAnalyticsIdentifier>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LogAnalyticsIdentifier)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLogAnalyticsIdentifier(document.RootElement, options);
        }

        internal static LogAnalyticsIdentifier DeserializeLogAnalyticsIdentifier(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Guid? workspaceId = default;
            string workspaceSubscriptionId = default;
            string workspaceResourceGroup = default;
            Guid? agentId = default;
            ResourceIdentifierType type = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("workspaceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    workspaceId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("workspaceSubscriptionId"u8))
                {
                    workspaceSubscriptionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("workspaceResourceGroup"u8))
                {
                    workspaceResourceGroup = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("agentId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    agentId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceIdentifierType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new LogAnalyticsIdentifier(
                type,
                serializedAdditionalRawData,
                workspaceId,
                workspaceSubscriptionId,
                workspaceResourceGroup,
                agentId);
        }

        BinaryData IPersistableModel<LogAnalyticsIdentifier>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LogAnalyticsIdentifier>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(LogAnalyticsIdentifier)} does not support writing '{options.Format}' format.");
            }
        }

        LogAnalyticsIdentifier IPersistableModel<LogAnalyticsIdentifier>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LogAnalyticsIdentifier>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLogAnalyticsIdentifier(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LogAnalyticsIdentifier)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LogAnalyticsIdentifier>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
