// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Indicates whether the extension is enabled. </summary>
    public readonly partial struct IsExtensionEnabled : IEquatable<IsExtensionEnabled>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IsExtensionEnabled"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IsExtensionEnabled(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> Indicates the extension is enabled. </summary>
        public static IsExtensionEnabled True { get; } = new IsExtensionEnabled(TrueValue);
        /// <summary> Indicates the extension is disabled. </summary>
        public static IsExtensionEnabled False { get; } = new IsExtensionEnabled(FalseValue);
        /// <summary> Determines if two <see cref="IsExtensionEnabled"/> values are the same. </summary>
        public static bool operator ==(IsExtensionEnabled left, IsExtensionEnabled right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IsExtensionEnabled"/> values are not the same. </summary>
        public static bool operator !=(IsExtensionEnabled left, IsExtensionEnabled right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IsExtensionEnabled"/>. </summary>
        public static implicit operator IsExtensionEnabled(string value) => new IsExtensionEnabled(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IsExtensionEnabled other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IsExtensionEnabled other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
