// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> IoT Security solution analytics severity metrics. </summary>
    public partial class IotSeverityMetrics
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotSeverityMetrics"/>. </summary>
        internal IotSeverityMetrics()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IotSeverityMetrics"/>. </summary>
        /// <param name="high"> Count of high severity alerts/recommendations. </param>
        /// <param name="medium"> Count of medium severity alerts/recommendations. </param>
        /// <param name="low"> Count of low severity alerts/recommendations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotSeverityMetrics(long? high, long? medium, long? low, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            High = high;
            Medium = medium;
            Low = low;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Count of high severity alerts/recommendations. </summary>
        public long? High { get; }
        /// <summary> Count of medium severity alerts/recommendations. </summary>
        public long? Medium { get; }
        /// <summary> Count of low severity alerts/recommendations. </summary>
        public long? Low { get; }
    }
}
