// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The IotSecuritySolutionDataSource. </summary>
    public readonly partial struct IotSecuritySolutionDataSource : IEquatable<IotSecuritySolutionDataSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotSecuritySolutionDataSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotSecuritySolutionDataSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TwinDataValue = "TwinData";

        /// <summary> Devices twin data. </summary>
        public static IotSecuritySolutionDataSource TwinData { get; } = new IotSecuritySolutionDataSource(TwinDataValue);
        /// <summary> Determines if two <see cref="IotSecuritySolutionDataSource"/> values are the same. </summary>
        public static bool operator ==(IotSecuritySolutionDataSource left, IotSecuritySolutionDataSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotSecuritySolutionDataSource"/> values are not the same. </summary>
        public static bool operator !=(IotSecuritySolutionDataSource left, IotSecuritySolutionDataSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotSecuritySolutionDataSource"/>. </summary>
        public static implicit operator IotSecuritySolutionDataSource(string value) => new IotSecuritySolutionDataSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotSecuritySolutionDataSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotSecuritySolutionDataSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
