// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Statistical information about the number of recommendations per device, per recommendation type. </summary>
    public partial class IotSecurityDeviceRecommendation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotSecurityDeviceRecommendation"/>. </summary>
        public IotSecurityDeviceRecommendation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IotSecurityDeviceRecommendation"/>. </summary>
        /// <param name="recommendationDisplayName"> Display name of the recommendation. </param>
        /// <param name="reportedSeverity"> Assessed recommendation severity. </param>
        /// <param name="devicesCount"> Number of devices with this recommendation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotSecurityDeviceRecommendation(string recommendationDisplayName, ReportedSeverity? reportedSeverity, long? devicesCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RecommendationDisplayName = recommendationDisplayName;
            ReportedSeverity = reportedSeverity;
            DevicesCount = devicesCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Display name of the recommendation. </summary>
        public string RecommendationDisplayName { get; }
        /// <summary> Assessed recommendation severity. </summary>
        public ReportedSeverity? ReportedSeverity { get; }
        /// <summary> Number of devices with this recommendation. </summary>
        public long? DevicesCount { get; }
    }
}
