// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Statistical information about the number of alerts per device during last set number of days. </summary>
    public partial class IotSecurityAlertedDevice
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotSecurityAlertedDevice"/>. </summary>
        public IotSecurityAlertedDevice()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IotSecurityAlertedDevice"/>. </summary>
        /// <param name="deviceId"> Device identifier. </param>
        /// <param name="alertsCount"> Number of alerts raised for this device. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotSecurityAlertedDevice(string deviceId, long? alertsCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeviceId = deviceId;
            AlertsCount = alertsCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Device identifier. </summary>
        public string DeviceId { get; }
        /// <summary> Number of alerts raised for this device. </summary>
        public long? AlertsCount { get; }
    }
}
