// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The IotSecurityAggregatedAlertTopDevice. </summary>
    public partial class IotSecurityAggregatedAlertTopDevice
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotSecurityAggregatedAlertTopDevice"/>. </summary>
        internal IotSecurityAggregatedAlertTopDevice()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IotSecurityAggregatedAlertTopDevice"/>. </summary>
        /// <param name="deviceId"> Name of the device. </param>
        /// <param name="alertsCount"> Number of alerts raised for this device. </param>
        /// <param name="lastOccurrence"> Most recent time this alert was raised for this device, on this day. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotSecurityAggregatedAlertTopDevice(string deviceId, long? alertsCount, string lastOccurrence, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeviceId = deviceId;
            AlertsCount = alertsCount;
            LastOccurrence = lastOccurrence;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the device. </summary>
        public string DeviceId { get; }
        /// <summary> Number of alerts raised for this device. </summary>
        public long? AlertsCount { get; }
        /// <summary> Most recent time this alert was raised for this device, on this day. </summary>
        public string LastOccurrence { get; }
    }
}
