// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary>
    /// Update Settings.
    ///
    /// Enabled - Resource should inherit configurations from parent.
    /// Disabled - Resource should not inherit configurations from parent.
    /// </summary>
    public readonly partial struct InheritFromParentState : IEquatable<InheritFromParentState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InheritFromParentState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InheritFromParentState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static InheritFromParentState Disabled { get; } = new InheritFromParentState(DisabledValue);
        /// <summary> Enabled. </summary>
        public static InheritFromParentState Enabled { get; } = new InheritFromParentState(EnabledValue);
        /// <summary> Determines if two <see cref="InheritFromParentState"/> values are the same. </summary>
        public static bool operator ==(InheritFromParentState left, InheritFromParentState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InheritFromParentState"/> values are not the same. </summary>
        public static bool operator !=(InheritFromParentState left, InheritFromParentState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InheritFromParentState"/>. </summary>
        public static implicit operator InheritFromParentState(string value) => new InheritFromParentState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InheritFromParentState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InheritFromParentState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
