// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The InformationProtectionPolicyName. </summary>
    public readonly partial struct InformationProtectionPolicyName : IEquatable<InformationProtectionPolicyName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InformationProtectionPolicyName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InformationProtectionPolicyName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EffectiveValue = "effective";
        private const string CustomValue = "custom";

        /// <summary> effective. </summary>
        public static InformationProtectionPolicyName Effective { get; } = new InformationProtectionPolicyName(EffectiveValue);
        /// <summary> custom. </summary>
        public static InformationProtectionPolicyName Custom { get; } = new InformationProtectionPolicyName(CustomValue);
        /// <summary> Determines if two <see cref="InformationProtectionPolicyName"/> values are the same. </summary>
        public static bool operator ==(InformationProtectionPolicyName left, InformationProtectionPolicyName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InformationProtectionPolicyName"/> values are not the same. </summary>
        public static bool operator !=(InformationProtectionPolicyName left, InformationProtectionPolicyName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InformationProtectionPolicyName"/>. </summary>
        public static implicit operator InformationProtectionPolicyName(string value) => new InformationProtectionPolicyName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InformationProtectionPolicyName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InformationProtectionPolicyName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
